function test_suite = testCos %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
x = polysym.empty;
y = cos(x);
assertTrue(isempty(y))

function testDefault
x = polysym;
y = cos(x);
assertEqual(y.Value,'1');

function testZero
x = polysym(0);
y = cos(x);
assertEqual(y.Value,'1');

function testZeroArray
x = polysym(zeros(1,3));
y = cos(x);
assertEqual(y(1).Value,'1');
assertEqual(y(2).Value,'1');
assertEqual(y(3).Value,'1');

function testRandReal
r = rand;
x = polysym(r);
y = cos(x);
assertEqual(y.Value,['cos(',x.Value,')']);
